---
Note type: Area
tags:
  - "#Area"
Area status: Active
Area type: Work
Priority: Medium
Related areas: 
Related projects: 
Related tasks:
  - "[[Develop individual development plan]]"
  - "[[Complete faculty activity report]]"
  - "[[Identify grant opportunities]]"
Related people:
  - "[[Dr. Jane Doe]]"
Related resources:
  - "[[University Faculty Mentoring Program Handbook]]"
  - "[[Tips for Effective Mentoring Relationships]]"
Related references: 
Related zettels: 
Related MoCs: 
aliases: 
Title: Mentoring
Creation date: 2024-04-17
Last modified: 2024-04-17
---

## Fleeting notes

### 2024-01-10
Several junior colleagues have reached out for advice on navigating the tenure process and building their dossiers. Look into developing some group mentoring opportunities and resources to complement individual efforts. Potential for monthly lunch discussions or writing accountability partnerships.

### 2024-03-20
Great conversation with mentee today about balancing teaching, research, and service. Reminder to share example schedules and planning templates. Continue these check-in meetings at least once a month and follow up on key milestones.

## General notes
I value mentoring as a means of fostering supportive relationships, facilitating professional development, and strengthening our scholarly community. I engage in mentoring in the following capacities:

Being mentored:
- Participate in formal mentoring program with Dr. Jane Doe
	- Monthly meetings to discuss goals, challenges, and progress
	- Feedback on grant proposals and manuscript drafts
	- Guidance on teaching, service, and work-life balance
	- Accountability for writing and research productivity
- Cultivate informal mentoring with senior scholars in field
	- Invite input on research ideas and career decisions
	- Seek opportunities for collaboration and sponsorship
	- Maintain regular contact at conferences and via email

Mentoring others:
- Serve as official mentor for 2 junior faculty
	- Help orient to department and university resources
	- Consult on research, teaching, and service strategies
	- Review dossier materials and provide developmental feedback
	- Connect to relevant contacts and opportunities
- Provide informal mentoring for graduate students
	- Advise on coursework, exams, and thesis/dissertation
	- Involve in research projects and co-authorship
	- Offer guidance on job market and alt-ac career options
	- Write recommendation letters and connect to networks
- Organize group mentoring and support
	- Facilitate monthly junior faculty writing group
	- Match new PhDs with dissertation coaching and accountability partners
	- Host sessions on time management, productivity, and resilience
	- Create online resource hub with links to articles, templates, and examples

Principles and best practices:
- Establish clear goals and expectations
- Meet regularly and follow through on action items
- Maintain confidentiality and professional boundaries
- Provide specific feedback and celebrate achievements
- Encourage self-reflection and independent problem-solving
- Be open to learning and two-way exchange
- Tailor approach to individual needs and style
- Know limits and refer to other resources as needed
- Regularly assess effectiveness and make adjustments
## Actionables

> [!project] Projects
> ```dataview
TABLE without id row.file.link as Projects
FROM "Actionables/Projects"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!task]+ Tasks
>  ```dataview
>TABLE without id row.file.link as Task, join(related-projects) as Project, join(do-date) as "Do Date", join(due-date) as "Due Date", join(task-size) as "Task Size", join(priority) as "Task Priority", 
>choice(done, "✅",":LiBoxSelect:") as Done, 
>choice(waiting-on-someone, "✅",":LiBoxSelect:") as "Waiting on Someone",
>choice(task-amnesty, "✅",":LiBoxSelect:") as "Task Amnesty" 
>FROM "Actionables/Tasks"
>WHERE contains(related-areas, [[]])
>SORT done ASC, task-amnesty ASC, waiting-on-someone ASC, choice(!do-date, date(2100-01-01), do-date) ASC, task-type DESC, choice(priority = "⚫ TBD", "1", choice(priority = "🔴 A", "2", choice(priority = "🟡 B", "3", choice(priority = "🟢 C", "4", choice(priority = "🟣 D", "5", choice(priority = "🔵 E", "6", "other")))))), choice(task-size = "🎂 Big", "1", choice(task-size = "🍰 Medium", "2", choice(task-size = "🧁 Small", "3", "other"))), priority ASC, choice(!due-date, date(2100-01-01), due-date) ASC, related-areas ASC, related-projects ASC
> ``` 
## Knowledge management system

> [!moc]- Maps of Content
> ```dataview
TABLE without id row.file.link as MoCs
FROM "Knowledge management system/Maps of Content"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!reference]- References
> ```dataview
TABLE without id row.file.link as References
FROM "Knowledge management system/References"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!zettel]- Zettelkasten
> ```dataview
TABLE without id row.file.link as Zettels
FROM "Knowledge management system/Zettelkasten"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

## Project management system

> [!meeting]- Meeting notes
> ```dataview
TABLE without id row.file.link as "Meeting Notes"
FROM "Project management system/Meeting notes"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!resource]- Resources
> ```dataview
TABLE without id row.file.link as Resources
FROM "Project management system/Resources"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

> [!person]- Rolodex
> ```dataview
TABLE without id row.file.link as People
FROM "Project management system/Rolodex"
WHERE contains(related-areas, [[]])
SORT file.ctime DESC
LIMIT 50
> ```

